unit Cimke3D;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
 TCimke3DStilus = (lsSullyesztett, lsKiemelt);

 TCimke3D = class(TLabel)
    private
      FStilus: TCimke3DStilus;
      procedure SetStilus(AStilus: TCimke3DStilus);
    protected
      procedure Paint; override;
    public
      constructor Create(AOwner: TComponent); override;
      procedure DoDrawText(var Rect: TRect;Flags: Longint); override;
    published
      property Stilus: TCimke3DStilus read FStilus write SetStilus
        default lsSullyesztett;
  end;

procedure Register;

implementation

// ---------------------------------------------------------------------------
constructor TCimke3D.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FStilus := lsSullyesztett;
end;

// ---------------------------------------------------------------------------
procedure TCimke3D.SetStilus(AStilus: TCimke3DStilus);
begin
  FStilus := AStilus;
  Invalidate;
end;

// ---------------------------------------------------------------------------
procedure TCimke3D.DoDrawText(var Rect: TRect;Flags: Longint);
var
  SzinMentes: TColor;
begin
  if not ShowAccelChar then
    // A '&' karakter megjelentse
    Flags := Flags or DT_NOPREFIX;
  Canvas.Font := Font; // a cmke bettpusa
  if Enabled then
  begin
    // A szveg kirsa a stt s a vilgos rsz
    // megjelentsvel
    SzinMentes := Canvas.Font.Color;

    if FStilus = lsSullyesztett then
      // Elszr stt
      Canvas.Font.Color := clBtnShadow
    else
      // Elszr vilgos
      Canvas.Font.Color := clBtnHighlight;
    // A szveg kirsa 1 pozcival feljebb s balra
    OffsetRect(Rect, -1, -1);
    DrawText(Canvas.Handle, PChar(Caption), Length(Caption), Rect, Flags);

    if FStilus = lsKiemelt then
      // Msodszor stt
      Canvas.Font.Color := clBtnShadow
    else
      // Msodszor vilgos
      Canvas.Font.Color := clBtnHighlight;
    // A szveg kirsa 2 pozcival lejjebb s jobbra
    OffsetRect(Rect, 2, 2);
    DrawText(Canvas.Handle, PChar(Caption), Length(Caption), Rect, Flags);
     // A szveg eredeti sznnek s pozcijnak visszalltsa
    OffsetRect(Rect, -1, -1);
    Canvas.Font.Color := SzinMentes;
  end
  else
    // A cmke vezrl le van tiltva
    Canvas.Font.Color := clGrayText;
  // A szveg megjelentse az eredeti pozcijban
  DrawText(Canvas.Handle, PChar(Caption), Length(Caption), Rect, Flags);
end;

// ---------------------------------------------------------------------------
// A vezrl jrarajzolsa
procedure TCimke3D.Paint;
const
  // A DrawText kiigaztsi konstansainak tmbje
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
var Rect: TRect;
    Flags: Longint;
begin
  with Canvas do
  begin
    if not Transparent then
    begin
      // Nem ttetsz httr esetn
      // a szveg alatti terlet kifestse httrsznnel
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(ClientRect);
    end;
    // ttetsz httr
    Brush.Style := bsClear;
    // A cmkt befoglal tglalap
    Rect:=ClientRect;
    // A DrawText mkdst vezrl konstansok
    Flags := DT_EXPANDTABS or DT_WORDBREAK or Alignments[Alignment];
    // A szveg megjelenttse
    DoDrawText(Rect,Flags);
  end;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TCimke3D]);
end;

end.
